/*         ______   ___    ___
 *        /\  _  \ /\_ \  /\_ \
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *
 *      Lets you draw pictures using pixel cubes. Under development.
 *
 *      By Elvang.
 */
#include <allegro.h>    // Allegro header file
#include <stdlib.h>       // Contains exit() function

/*Timer Start*/
volatile long speed_counter = 0;     // Speed variable

void increment_speed_counter()       // Increments Speed Variable
{                                    //~
     speed_counter++;                //~
}                                    //~
END_OF_FUNCTION(increment_speed_counter);
/*Timer End*/

void initialize();                       // Function initializes everything at start

/*Main Start*/
int main(int argc, char *argv[])
{
    initialize();  // Initializes everything needed
    
    DATAFILE *cubes = load_datafile("Cubes.dat");  // Contains the various cube bitmaps
    BITMAP *buffer = create_bitmap(800,600);     // Bitmap for buffering
    BITMAP *work = create_bitmap(800, 600);      // Bitmap to save cubes already placed
    BITMAP *cube = (BITMAP*) cubes[0].dat;
    
    int cube_x_position = 0; // Cube's x position
    int cube_y_position = 0; // Cube's y position
    int cube_color = 0;      // Current Cube's Color
    
    while(!key[KEY_ESC])
    {
         while(speed_counter > 0)
         {
              if(key[KEY_EQUALS])       // Cycles through the different cubes
              {
                   cube_color++;
                   if(cube_color > 7)
                        cube_color = 0;
                   cube = (BITMAP*) cubes[cube_color].dat;                        
              }
              
              if(key[KEY_MINUS])       // Cycles through the different cubes in reverse
              {
                   cube_color--;
                   if(cube_color < 0)
                        cube_color = 7;
                   cube = (BITMAP*) cubes[cube_color].dat;
              }
              
              if(key[KEY_UP])       // Moves cube up
                   cube_y_position -=  3;
                   
              if(key[KEY_DOWN])    // Moves cube down
                   cube_y_position += 3;
              
              if(key[KEY_LEFT])    // Moves cube left
                   cube_x_position -= 3;
              
              if(key[KEY_RIGHT])   // Moves cube right
                   cube_x_position += 3;
                   
              if(key[KEY_SPACE])   // Saves cube's position
                   draw_sprite(work, cube, cube_x_position, cube_y_position);
                   
              speed_counter--;
         }    // End of while(speed_counter > 0)
         draw_sprite(buffer, work, 0, 0);   // Draws saved work to buffer
         draw_sprite(buffer, cube, cube_x_position, cube_y_position);    // Draws current cube to buffer
         blit(buffer, screen, 0, 0, 0, 0, 800, 600);                     // Draws the buffer to the screen
         clear(buffer);       // Clears the buffer
         
    }    // End of while(!key[KEY_ESC])
    
    destroy_bitmap(buffer);            //Release bitmaps
    destroy_bitmap(cube);              //~
    destroy_bitmap(work);              //~
    
    unload_datafile(cubes);            //Release datafiles
    
    return 0;
}
END_OF_MAIN();
/*Main End*/

/*Initialize Start*/
void initialize()
{
     allegro_init();  // Initializes Allegro
     install_keyboard(); // Initializes Keyboard Routines
     install_timer();    // Initializes Timer Routines
     
     LOCK_VARIABLE(speed_counter);
     LOCK_FUNCTION(increment_speed_counter);
     install_int_ex(increment_speed_counter, BPS_TO_TIMER(30));  // Sets Beats Per Second(Game Speed), Higher is Faster
     
     set_color_depth(16);                    // Sets the color depth
     set_gfx_mode(GFX_AUTODETECT, 800, 600, 0, 0);   // Sets screen resolution
}
END_OF_FUNCTION(initialize);
/*Initialize End*/
